/*
 *
 *                       ADOBE CONFIDENTIAL
 *                     _ _ _ _ _ _ _ _ _ _ _ _
 *
 * Copyright 2006, Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of this material is
 * strictly forbidden unless prior written permission is obtained from Adobe
 * Systems Incorporated.
 *
 * Author: Varahamurthy Jutur, 09-JAN-2015
 */

document.addEventListener('DOMContentLoaded', function(event) {
   //alert('DOM fully loaded and parsed');
   var messageQueue = {};
   var nextId = 0;
   var loaderTimeOuts = {};
   var LOAD_TIMEOUT = 5000;

    function isIEBrowser(){
        var ua = window.navigator.userAgent;
        var msie = ua.indexOf('MSIE ');
        var trident = ua.indexOf('Trident/');

        if (msie > 0) {
            // IE 10 or older => return version number
            return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
        }

        if (trident > 0) {
            // IE 11 (or newer) => return version number
            var rv = ua.indexOf('rv:');
            return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
        }

        // other browser
        return false;      
    }

    function createTreeWalker(documentObj, rootNode, whatToShow, filter, entityReferenceExpansion){
      if(isIEBrowser())
      {
        return documentObj.createTreeWalker(rootNode, whatToShow, filter.acceptNode, (entityReferenceExpansion)?true:false);
      }
      else
        return documentObj.createTreeWalker(rootNode, whatToShow, filter, (entityReferenceExpansion)?true:false);
    }    

    window.addEventListener("message", receiveMessage, false);

    function receiveMessage(event)
    {
      var node = messageQueue[event.data.id];      
      if(event.data.msg === "FALLBACK_URL")
      {
        var newPath = event.data.newPath;
        if(node)
        {
          if(node.tagName == 'embed')
          {
            // For embed tag, looks like just setting the src, will not trigger a reload.
            // So we create a new embed tag and replace the old one with the new.
            var newEmbedNode = document.createElement('embed');
            //TODO we need to replicate all other properties of the original embed tag to the new one.
            //newEmbedNode.setAttribute('type', event.data.newMimeType);            
            newEmbedNode.setAttribute('src', newPath);
            node.parentNode.replaceChild(newEmbedNode, node);
          }
          else
          {
            // console.log("newpath: " + newPath);
            node.src = newPath;          
          }
        }
      }
      else if(event.data.msg === "GET_BINDINGS_RESPONSE")
      {
        var newPath = event.data.newPath;
        if(!newPath || newPath == "")
        {
          // If we are here, it means the opf does not have any binding specifed for this media type.
          // So just ignore this response, so that intrinsic fallbacks kick-in.
          return;
        }
        var queryString = "";
        if(node.data)
        {
          queryString = queryString + "?src=" + node.data;
          if(node.getAttribute('type'))
            queryString = queryString + "&type=" + node.getAttribute('type');
          var nodeChildren = node.childNodes;
          for(var i=0;i<nodeChildren.length;i++)
          {
            var childNode = nodeChildren[i];
            if(childNode.tagName === 'param')
            {
              var name = childNode.getAttribute('name');
              var value = childNode.getAttribute('value');
              queryString = queryString + "&"+name+"="+value;
            }
          }
        }
        newPath = newPath + encodeURI(queryString);
        var newNode = document.createElement('iframe');        
        // newNode.setAttribute('type', event.data.newMimeType);
        newNode.setAttribute('src', newPath);
        newNode.style.border = "0px";
        newNode.style.width = "auto";
        newNode.style.height = "auto";
        // newNode.setAttribute('width', 'auto');
        // newNode.setAttribute('height', 'auto');
        // newNode.setAttribute('frameBorder', '0');
        // newNode.setAttribute('border-width', '0px');
        // newNode.setAttribute('seemless', 'seemless');        
        node.parentNode.replaceChild(newNode, node);
        // node.data = newPath;
        // node.type = event.data.newMimeType;
      }
      delete messageQueue[event.data.id];      
        // console.log("receiveMessage: "+ event.data.path + " \n _manifestFallbacks: " + JSON.stringify(ReadiumSDK.reader.getManifestFallbacks()));
    }   

   // console.log('DOM fully loaded and parsed');
   var topmostWin = window;
   while(topmostWin && topmostWin.parent && topmostWin !== window.parent)
   {
      topmostWin = window.parent;
   }

    try{
        if(MathJax)
        {
          MathJax.Hub.Startup.signal.Interest(function (message) { 
            if(message === 'End')
            {
              if(topmostWin.ReadiumSDK)
              {
                topmostWin.ReadiumSDK.reader.setStyles([], false);
              }
              else
              {
                //alert('topmostWin.AdobeRDMHelper is not available');
                console.error('topmostWin.AdobeRDMHelper is not available');
              }
              
            }
          });
        }
    }catch(err){
        console.error("MathJax.Hub.Startup.signal.Interest: register failed: " + err);
    }        

   function applyFallbackOnError(){
       // console.log('image load error: ' + this.src);
       // console.log("top most window: " + topmostWin);
       // console.log("this.tagName: " + this.tagName);
       messageQueue[nextId] = this;
       topmostWin.postMessage({path:this.src, msg:"LOAD_FAILED", id:nextId},"*");
       nextId++;
       delete loaderTimeOuts[this];       
   }

   function applyEpub3BindingOnError(){
        console.log("applyEpub3BindingOnError");
       messageQueue[nextId] = this;
       topmostWin.postMessage({path:this.data || this.src,
        targetHandlerIndex: 0,
        mimeType:this.type,
        msg:"GET_BINDINGS", 
        id:nextId},"*");
       nextId++;
       delete loaderTimeOuts[this];       
   }   

      // Go through the 'iframe', 'embed' and 'img' tags and error handlers.
      // When an error occurs on these nodes, we postMessage() to topmost window and get the fallback path and apply it
      var tmp = document.body;
      var iter = createTreeWalker(document, document, NodeFilter.SHOW_ELEMENT, {acceptNode: function (node){
        if ( node.tagName === 'img' || node.tagName === 'iframe' || node.tagName === 'embed' || node.tagName == 'object' || node.tagName === 'meter') {
          return NodeFilter.FILTER_ACCEPT;
        }
        return NodeFilter.FILTER_SKIP;        
      }}, false);
      tmp = iter.currentNode;
      while(tmp && tmp.nodeType !== Node.TEXT_NODE)
      {
          if(tmp.tagName === 'embed' || tmp.tagName === 'iframe')
          {
            tmp.onload = function(){
              clearTimeout(loaderTimeOuts[this]);
              delete loaderTimeOuts[this];
            };
            loaderTimeOuts[tmp] = setTimeout(applyFallbackOnError.bind(tmp), LOAD_TIMEOUT);
          }
          else if(tmp.tagName === 'img')
          {
              tmp.onerror = function(){
                applyFallbackOnError.bind(this)();
              };
          }
          else if(tmp.tagName === 'object')
          {
              if (isIEBrowser()) // for epub-test-org case svg-420
              {                     
                  var newPath = tmp.data;
                  var newType = tmp.type;
                  var svg = newType.indexOf('svg');
                  if (svg > -1)
                  {
                      var newNode = document.createElement('embed');
                      newNode.setAttribute('src', newPath);
                      newNode.setAttribute('type', newType);
                      tmp.parentNode.replaceChild(newNode, tmp);
                  }                  
              }
              tmp.onload = function(){
              clearTimeout(loaderTimeOuts[this]);
              delete loaderTimeOuts[this];
            };
            loaderTimeOuts[tmp] = setTimeout(applyEpub3BindingOnError.bind(tmp), LOAD_TIMEOUT);
          }
		   else if (tmp.tagName === 'meter')
          {
              if (isIEBrowser())
              {
                  var newMin = tmp.getAttribute('min');
                  var newMax = tmp.getAttribute('max');
                  var newVal = tmp.getAttribute('value');
                  var style = "color:green;background:white";

                  var newNode = document.createElement('progress');
                  newNode.setAttribute('min', newMin);
                  newNode.setAttribute('max', newMax);
                  newNode.setAttribute('value', newVal);
                  newNode.setAttribute('style', style);
                  tmp.parentNode.replaceChild(newNode, tmp);
              }
          }
          tmp = iter.nextNode();
      }
});